//+------------------------------------------------------------------+
//|                                               WCCISqueeze v1.mq4 |
//|                                                                  |
//|                                           Original BBSqueeze.mq4 |
//|                Copyright  2005, Nick Bilak, beluck[AT]gmail.com |
//|                                    http://metatrader.50webs.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, ch33z3"
#property link      "http://4xjournal.blogspot.com/"

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_color2 Green
#property indicator_color3 Blue
#property indicator_color4 Black

SetLevelStyle(2,1,Red);
SetLevelValue(1,-200);
SetLevelValue(2,-100);
SetLevelValue(3,100);
SetLevelValue(4,200);

extern int TCCIPeriod=6;
extern int CCIPeriod=14;
extern int ApplyTo=5;
extern int BBPeriod=20;
extern double BBDeviation=2.0;
extern int KCPeriod=20;
extern double KCFactor=1.5;
extern bool SqueezeAlertBox=false;
extern bool SqueezeAudioAlert=false;
extern bool BreakAlertBox=false;
extern bool BreakAudioAlert=false;

double upK[];
double loK[];
double TCCIBuffer[];
double CCIBuffer[];

int init()
  {
   
   SetIndexStyle(0,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(0,upK);
   
   SetIndexStyle(1,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(1,loK);
   
   SetIndexStyle(2,DRAW_LINE,0,2);
   SetIndexBuffer(2,CCIBuffer);
   
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,TCCIBuffer);
   
   string title="CCI("+CCIPeriod+") TCCI("+TCCIPeriod+")";
   IndicatorShortName(title);
   SetIndexLabel(0,title);
   
   return(0);
  }
  
int start() {

   int i, counted_bars=IndicatorCounted();
   if(Bars<=TCCIPeriod || Bars<=CCIPeriod) return(0);
   
   if (counted_bars<1) {
      for(i=1;i<=TCCIPeriod;i++) TCCIBuffer[Bars-i]=0.0;
      for(i=1;i<=CCIPeriod;i++) CCIBuffer[Bars-i]=0.0;
   }
   
   int limit=Bars-counted_bars;
   if(counted_bars>0) limit++;
   
   double diff, std, bbs;
   for(i=0; i<=limit; i++) {
   
   TCCIBuffer[i]=iCCI(NULL,0,TCCIPeriod,ApplyTo,i);
   CCIBuffer[i]=iCCI(NULL,0,CCIPeriod,ApplyTo,i);
   
   diff = iATR(NULL,0,KCPeriod,i)*KCFactor;
   std = iStdDev(NULL,0,BBPeriod,MODE_SMA,0,PRICE_CLOSE,i);
	bbs = BBDeviation * std / diff;
		
   if(bbs<1) {
      upK[i]=CCIBuffer[i];
      loK[i]=0; 
   
       
      if (SqueezeAlertBox == true && i == 0) Alert("Squeeze Zone Alert for ", Symbol(), " on ", Period(), " chart!");
      if (SqueezeAudioAlert == true && i == 0) PlaySound("alert.wav"); 
            
   } else {
      loK[i]=CCIBuffer[i];
      upK[i]=0;
      
      if (BreakAlertBox == true && i == 0) Alert("Break Out Alert for ", Symbol(), " on ", Period(), " chart!");
      if (BreakAudioAlert == true && i == 0) PlaySound("alert.wav"); } }
   return(0);
   }
  
//+------------------------------------------------------------------+